/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards.variableTypes;

import chanceCubes.CCubesCore;
import chanceCubes.rewards.variableParts.ListPart;
import chanceCubes.rewards.variableParts.RandomPart;
import chanceCubes.rewards.variableParts.StringPart;
import chanceCubes.rewards.variableTypes.CustomVar;
import org.apache.logging.log4j.Level;

public class IntVar
extends CustomVar {
    public IntVar() {
    }

    public IntVar(int val) {
        super.addPart(new StringPart(val));
    }

    public IntVar(Integer[] val) {
        this.addPart(new ListPart<Integer>(val));
    }

    public int getIntValue() {
        String val = super.getValue();
        if (IntVar.isInteger(val)) {
            return Integer.parseInt(val);
        }
        CCubesCore.logger.log(Level.ERROR, "An Error occurred while processing a Reward value! " + val + " is not an integer!");
        return 0;
    }

    public static RandomPart<Integer> parseRandom(String input) {
        if ((input = input.replaceAll(" ", "")).charAt(3) == '(' && input.indexOf(41, 3) != -1) {
            String[] randParams = input.substring(4, input.lastIndexOf(41)).split(",");
            if (randParams.length == 1 && IntVar.isInteger(randParams[0])) {
                return new RandomPart<Integer>(0, Integer.parseInt(randParams[0]));
            }
            if (randParams.length == 2 && IntVar.isInteger(randParams[0]) && IntVar.isInteger(randParams[1])) {
                return new RandomPart<Integer>(Integer.parseInt(randParams[0]), Integer.parseInt(randParams[1]));
            }
        }
        return new RandomPart<Integer>(0, 1);
    }

    public static boolean isInteger(String input) {
        return input.matches("[-+]?\\d*");
    }
}

